package examples.localserver;

import ru.uss.esf.api1.invoice.signable.IdList;
import ru.uss.esf.model.SignableDataContainer;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ListSignatureRequest")
public class ListSignatureRequest implements SignableDataContainer<IdList> {
    @XmlElementWrapper(required = true)
    @XmlElement(name = "id", required = true)
    private List<Long> ids;

    @XmlElement(required = true)
    @Documentation("Путь к сертификату на локальном компьютере")
    private String certificatePath;

    @XmlElement(required = true)
    @Documentation("Пароль к контейнеру с сертификатом")
    private String certificatePin;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getCertificatePath() {
        return certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePin() {
        return certificatePin;
    }

    public void setCertificatePin(String certificatePin) {
        this.certificatePin = certificatePin;
    }

    @Override
    public IdList getSignableData() {
        return new IdList(ids);
    }
}
